

<?php $__env->startSection('content'); ?>
<div class="card mt-3">
    <div class="card-header">
        Games List
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-12">
                <div class="modal fade" id="tambah_banner" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <form action="<?php echo e(URL::to('banner')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo e(csrf_field()); ?>

                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">Tambah Data Banner</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1" class="form-text text-muted">Judul
                                                    :</label>
                                                <input name="nama" type="text" class="form-control" placeholder="Judul Banner" value="">
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1" class="form-text text-muted">Gambar
                                                    Banner :</label>
                                                <input name="gambar" type="file" class="form-control uploads" accept="image/png, image/jpg, image/jpeg">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <input type="hidden" name="status" value="1">
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-danger">Tambah</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="table-responsive">

            <table id="example2" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th class="text-center">Provider</th>
                        <th class="text-center">Game ID</th>
                        <th class="text-center">Game</th>
                        <th class="text-center">Category</th>
                        <th class="text-center">Image</th>
                        <th class="text-center">Locked</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $game_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($item->provider); ?></td>
                        <td><?php echo e($item->game_id); ?></td>
                        <td><?php echo e($item->game_name); ?></td>
                        <td><?php echo e($item->category); ?></td>
                        <td  class="text-center">
                            <img src="<?php echo e($item->image_is_url === 1 ? $item->image : asset($item->image)); ?>" alt="<?php echo e($item->game_name); ?>" style="max-width: 120px">
                        </td>
                        <td>
                            <?php if($item->status == 1): ?>
                            <span class="badge badge-success">Aktif</span>
                            <?php else: ?>
                            <span class="badge badge-danger">Terkunci</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($item->game_locked == 0): ?>
                            <a href="<?php echo e(URL::to('game_setting_lock').'?game_id='.$item->id); ?>" class="btn btn-dark"><i class="fas fa-eye-slash"></i> Kunci</a>
                            <?php else: ?>
                            <a href="<?php echo e(URL::to('game_setting_unlock').'?game_id='.$item->id); ?>" class="btn btn-primary"><i class="fas fa-eye"></i> Buka Kunci</a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {

        $('#example2').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            bAutoWidth: false,
            aoColumns: [{
                    sWidth: '5%'
                },
                {
                    sWidth: '10%'
                },
                {
                    sWidth: '15%'
                },
                {
                    sWidth: '10%'
                },
                {
                    sWidth: '10%'
                },
                {
                    sWidth: '10%'
                },
                {
                    sWidth: '10%'
                },
                {
                    sWidth: '10%'
                },
            ]
        });
    })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backoffice.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u118372801/domains/top-alternatifku.my.id/public_html/resources/views/backoffice/games/game_setting.blade.php ENDPATH**/ ?>