<?php
    use App\Models\Saldo;
    ?>

<?php
    $saldo = Saldo::where('user_id', Auth::user()->id)->first();

    $saldo = empty($saldo) ? (Object) ['saldo' => 0, 'bonus' => 0] : $saldo;
?>
<div class="header-mobile">
    <div class="header-mobile__marquee">
        <i class="fas fa-bullhorn"></i>
        <marquee class="marquee"><?php echo e($setting->running_texts); ?></marquee>
    </div>
    <div class="header-mobile__top">
        <div class="mobile-logo">
            <a href="<?php echo e(URL::to('/')); ?>" title="" class="logo">
                <?php

                // file mp4 check
                if (substr($setting->logo, strlen($setting->logo) - 3) == 'mp4') {
                ?>
                    <video width="auto" height="40" autoplay loop muted>
                        <source src="<?php echo e(asset('/storage/logo/'.$setting->logo)); ?>" type="video/mp4" />
                    </video>
                <?php
                } else {
                ?>
                    <img class="img-fluid" alt="<?php echo e($setting->nama_web); ?>" src="<?php echo e(asset('/storage/logo/'.$setting->logo)); ?>" />
                <?php
                }
                ?>
            </a>
        </div>
        <div class="mobile-right">
            <?php if(auth()->guard()->check()): ?>
            <div class="mobile-balance">
                <a class="btn-wallet-load"><span><i class="fa fa-sync"></i></span></a>
                <a class="wallet-amount" id="wallet-amount" href="#" data-toggle="modal" data-target="#accountBalance"> 
                    <span>IDR
                    <span id="mainBalance" name="mainBalance"><?php echo number_format($saldo->saldo + $saldo->bonus,2); ?></span>
                </a>
            </div>
            <?php endif; ?>
            <div class="mobile-button">
                <?php if(auth()->guard()->check()): ?>
                <button class="btn-login" type="button" type="button" data-toggle="modal" data-target="#loginModal">Logout</button>
                <?php endif; ?>

                <?php if(auth()->guard()->guest()): ?>
                <button class="btn-login" type="button" type="button" data-toggle="modal" data-target="#loginModal">Masuk</button>
                <button class="btn-register" onclick="window.location.href = 'register'">Daftar</button>
                <?php endif; ?>
                <div class="mobile-menu sidenav-open">
                    <div class="mobile-menu--line">

                    </div>
                </div>
            </div>
        </div>
        <div id="mobilePageLoadingBar" class="progress-bar progress-bar-success" role="progressbar" style="height:4px;width:1%;position:absolute;z-index:999;display:none;"></div>
    </div>
    <header class="header" id="header-desktop">

        <div id="pageLoadingBar" class="progress-bar progress-bar-success" role="progressbar" style="height:4px;width:1%;position:absolute;z-index:999;"></div>
        <div class="container-fluid">
            <div class="header__container">
                <div class="container-item">
                    <div class="header-marquee">
                        <marquee class="marquee">
                            <?php echo e($setting->running_texts); ?>

                        </marquee>
                    </div>
                </div>
                <div class="container-item">
                    <div class="header-form">
                        <div class="form-button">

                            <?php if(auth()->guard()->check()): ?>
                            <button class="btn-login" type="button" type="button" data-toggle="modal" data-target="#loginModal">Logout</button>
                            <?php endif; ?>

                            <?php if(auth()->guard()->guest()): ?>
                            <button class="btn-login" type="button" type="button" data-toggle="modal" data-target="#loginModal">Masuk</button>
                            <button class="btn-register" onclick="window.location.href = 'register'">Daftar</button>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </header>
    <script>
            $(function(){
                $(document).on('click', '.btn-wallet-load', function(e){
                    e.preventDefault();

                    $('.btn-wallet-load').addClass('icon-spin');
                    const url = "<?php echo e(URL::to('user-saldo-refresh')); ?>";
                    $.get(url, function(data){
                        $('.btn-wallet-load').removeClass('icon-spin');
                        let datas = JSON.parse(data);   
                        if(datas.error === false){
                            $('.bal-txt').text('IDR ' + datas.balance.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",") + '.00');
                        }
                    })
                })
            })
        </script><?php /**PATH E:\xampp_8\htdocs\fix_two_week\resources\views/layouts/mpo/header.blade.php ENDPATH**/ ?>